<?php
if ($argc < 2) {
    print "$argv[0]: klasy1.php [, ...]\n";
    exit;
}

// Wczenie plikw
foreach(array_slice($argv, 1) as $filename) {
    include_once $filename;
}

// Pobranie informacji o wszystkich metodach i funkcjach
// Na pocztek dane method
$methods = array();
foreach (get_declared_classes() as $class) {
    $r = new ReflectionClass($class);
    // Odrzucenie klas wbudowanych
    if ($r->isUserDefined()) {
        foreach ($r->getMethods() as $method) {
            // Odrzucenie metod dziedziczonych
            if ($method->getDeclaringClass()->getName() == $class) {
                $signature = "$class::" . $method->getName();
                $methods[$signature] = $method;
            }
        }
    }
}

// Nastpnie dane funkcji
$functions = array();
$defined_functions = get_defined_functions();
foreach ($defined_functions['user'] as $function) {
    $functions[$function] = new ReflectionFunction($function);
}

// Sortowanie alfabetyczne metod wzgldem nazw klas
function sort_methods($a, $b) {
    list ($a_class, $a_method) = explode('::', $a);
    list ($b_class, $b_method) = explode('::', $b);

    if ($cmp = strcasecmp($a_class, $b_class)) {
        return $cmp;
    }
  
    return strcasecmp($a_method, $b_method);
}
uksort($methods, 'sort_methods');

// Sortowanie alfabetyczne funkcji
// Zadanie jest nieco mniej skomplikowane, ale nie mona zapomnie o
// usuniciu z listy funkcji sortowania metod.
unset($functions['sort_methods']);
// Sortowanie
ksort($functions);

// Wywietlenie wyniku
foreach (array_merge($functions, $methods) as $name => $reflect) {
    $file = $reflect->getFileName();
    $line = $reflect->getStartLine();

    printf (%-25s | %-40s | %6d\n", "$name()", $file, $line);
}
?>
